var config = require('../../config');
let app = getApp();
Page({
  data: {
    userAuth: false, // 用户信息授权（为了拿unionId）
    unionAuth: false, // unionId授权: 如果为false是需要授权，true是不需要
    stepAuth: false, // 步数授权
    // commitStepPopupShow: false, // 同步步数成功弹窗
    activityExplainShow: false, // 活动说明弹窗
    currentSteps: 0,
    targetSteps: 0,
    stepRecordList: [],
    showGetUserInfo: false,
    isFirstReq: true,
    reCheck: false,
    scene: 1001,
    progressCanvasContext: '',
    progressCanvasRate: '',
    progressCanvasImage: '',
    bubbleList: [],
  },
  
  onShow() {
    wx.showLoading({
      title: '获取步数中'
    });
    this.setData({
      scene: app.globalData.scene
    });
    this.getPageData();
    this.earnStep();
  },

  onReady() {
    const rate = wx.getSystemInfoSync().screenWidth / 750,
      context = wx.createCanvasContext('progressCanvas');
    context.translate(375 * rate, 255 * rate);
    this.data.progressCanvasContext = context;
    this.data.progressCanvasRate = rate;
    // 画进度条总长
    context.setStrokeStyle('rgba(255, 255, 255, 0.4)');
    context.setLineWidth(4 * rate);
    context.setLineCap('round');
    context.beginPath();
    context.arc(0, 0, 245 * rate, 0.90625 * Math.PI, 2.09375 * Math.PI, false);
    context.stroke();
    // 画刻度
    context.setStrokeStyle('#ffffff');
    context.setLineWidth(4 * rate);
    context.rotate(-0.09375 * Math.PI);
    context.beginPath();
    const keduLeft = -230 * rate,
      keduRight = -220 * rate,
      oneKedu = 0.03125 * Math.PI;
    context.moveTo(keduLeft, 0);
    context.lineTo(keduRight, 0);
    context.stroke();
    for (let i = 0; i < 38; i++) {
      context.rotate(oneKedu);
      context.beginPath();
      context.moveTo(keduLeft, 0);
      context.lineTo(keduRight, 0);
      context.stroke();
    }
    // 画当前圆球
    context.setFillStyle('#ffffff');
    context.rotate(2.544);
    context.arc(-245 * rate, 0, 7 * rate, 0, 2 * Math.PI, false);
    context.fill();
    // 画
    context.draw(false, drawRes => {
      if (drawRes.errMsg === 'drawCanvas:ok') {
        wx.canvasToTempFilePath({
          canvasId: 'progressCanvas',
          success:(ImageRes) => {
            this.setData({
              progressCanvasImage: ImageRes.tempFilePath
            });
          }
        });
      } else {
        // 重画
      }
    });
  },

  getPageData() {
    // 1、第一步，先判断用户信息和步数是否授过权
    wx.getSetting({
      success:(res) => {
        // 用户信息是否授权
        if (res.authSetting['scope.userInfo']) {
          app.globalData.userAuth = true;
        }
        // 微信步数是否授权
        if (res.authSetting['scope.werun']) {
          app.globalData.stepAuth = true;
        }
        // 2、询问后端是否需要unionId授权
        this.needUnionAuth().then(unionRes => {
          app.globalData.unionAuth = unionRes;
          console.log('needUnionAuth',app.globalData.unionAuth,app.globalData.userAuth,app.globalData.stepAuth)
          // 视图层数据赋值
          this.setData({
            userAuth: app.globalData.userAuth,
            unionAuth: app.globalData.unionAuth,
            stepAuth: app.globalData.stepAuth
          });
          if (app.globalData.unionAuth && app.globalData.stepAuth) {
            this.getClickStepData();
          } else if (app.globalData.stepAuth) {
            this.loadStepData();
          } else {
            wx.hideLoading();
          }
        });
      }
    });
  },

  // 询问后端是否需要unionId授权
  needUnionAuth() {
    return new Promise((resolve, reject) => {
      wx.login({
        success:wxres => {
          if (wxres.code) {
            wx.request({
              url: config.service.hostUrl + "/v1/auth_login",
              data: {
                js_code: wxres.code
              },
              method: 'POST',
              success:myres => {
                if (myres.data.code === 0) {
                  app.globalData.userInfo = myres.data.data;
                  app.globalData.token = myres.data.data.token;
                  resolve(true);
                } else if (myres.data.data.code === 401) {
                  resolve(false);
                }
              }
            });
          }
        }
      });
    });
  },

  // 页面加载时请求的展示步数数据
  loadStepData() {
    console.log('loadStepData')
    wx.getWeRunData({
      success:(stepres) => {
        wx.login({
          success:wxres => {
            if (wxres.code) {
              wx.request({
                url: config.service.hostUrl + "/v1/get_step_num",
                data: {
                  js_code: wxres.code,
                  encrypted_data: stepres.encryptedData,
                  iv: stepres.iv
                },
                method: 'POST',
                success:(res) => {
                  const resData = res.data.data;
                  this.setData({
                    currentSteps: (resData && resData[0]) ? resData[0].step : 0,
                    stepRecordList: resData
                  });
                  // wx.showModal({
                  //   content: '获取微信运动步数成功',
                  //   showCancel: false
                  // });
                },
                complete: () => {
                  wx.hideLoading();
                }
              });
            }
          }
        });
      },
      fail:(err) => {
        console.log(err)
        this.getWeRunDataFail(err);
      }
    });
  },

  // 用户点击提交步数打卡1（处理授权情况）
  clickStepData() {
    console.log('clickStepData')
    // if (!this.data.reCheck && !this.data.isFirstReq && wx.getStorageSync('getStepLoading') && Date.now() - wx.getStorageSync('getStepLoading') < 60000) {
    //   wx.showToast({
    //     title: '已是最新步数，建议前往微信运动获取最新步数再返回同步',
    //     icon: 'none',
    //     duration: 2000
    //   });
    //   return;
    // }
    let needStepAuth = (reCheck) => {
      wx.authorize({ // 调起授权窗口
        scope: 'scope.werun',
        success:() => { // 授权成功
          app.globalData.stepAuth = true;
          this.setData({
            stepAuth: true
          });
          if (reCheck) {
            this.data.reCheck = true;
            this.clickStepData();
          } else {
            this.getClickStepData();
          }
        },
        fail:(err) => { // 授权失败，因为用户拒绝或者用户曾经拒绝过，而且在这里不能直接去到openSetting页，需要通过一个弹窗中转过去
          this.authorizationFail();
        }
      });
    }
    if (app.globalData.unionAuth) { // 不需要unionId授权
      if (app.globalData.stepAuth) { // 步数已授权
        this.getClickStepData();
      } else { // 步数没有授权，弹出步数授权框
        needStepAuth();
      }
    } else { // 需要unionId授权
      if (!app.globalData.userAuth && !app.globalData.stepAuth) {
        wx.navigateTo({
          url: '/pages/authorization/authorization'
        });
      } else if (!app.globalData.userAuth && app.globalData.stepAuth) {
        this.showUserInfoPopup();
      } else if (app.globalData.userAuth && !app.globalData.stepAuth) {
        needStepAuth(true);
      } else if (app.globalData.userAuth && app.globalData.stepAuth) {
        wx.getUserInfo({
          withCredentials: true,
          success:(userres) => {
            this.sendUserInfo(userres.encryptedData, userres.iv);
          }
        });
      }
    }
  },

  // 用户点击提交步数打卡2（处理获步数和提交）
  getClickStepData() {
    console.log('getClickStepData')
    wx.getWeRunData({
      success:(stepres) => {
        wx.request({
          url: config.service.hostUrl + "/v1/sync_step_data",
          data: {
            encrypted_data: stepres.encryptedData,
            iv: stepres.iv
          },
          header: {
            'Authorization': app.globalData.token
          },
          method: 'POST',
          success:(res) => {
            this.data.isFirstReq = false;
            const resData = res.data.data;
            // 数据处理，结合两个数组判断是否显示打卡角标和状态
            const joinDate = [];
            resData.records_info.forEach(item => {
              joinDate.push(item.period);
            });
            resData.step_data.forEach(item => {
              if (joinDate.indexOf(item.period) > -1) {
                if (resData.records_info[joinDate.indexOf(item.period)].daka_done) {
                  item.status = 1; // 打卡成功
                } else {
                  item.status = 2; // 打卡失败
                }
              } else {
                item.status = 0; // 未参与打卡
              }
            });
            wx.setStorageSync('getStepLoading', Date.now());
            // 避免没有目标步数，不好比较是否达标
            const setData = {
              targetSteps: resData.total_step,
              stepRecordList: resData.step_data
            };
            if (resData.total_step > 0) {
              // this.changeShowPopup();
              const realCurrentSteps = (resData.step_data && resData.step_data[0]) ? resData.step_data[0].step : 0;
              this.dynamicDrawCanvas(realCurrentSteps, (realCurrentSteps > resData.total_step ? resData.total_step : realCurrentSteps) / 100);
            } else {
              setData.currentSteps = (resData.step_data && resData.step_data[0]) ? resData.step_data[0].step : 0;
            }
            this.setData(setData);
            wx.hideLoading();
            this.showToast();
          },
          fail: () => {
            wx.hideLoading();
          }
        });
      },
      fail:(err) => {
        console.log(err)
        this.getWeRunDataFail(err);
      }
    });
  },

  // 让canvas动起来
  dynamicDrawCanvas(realCurrentSteps, increment) {
    setTimeout(() => {
      if (this.data.currentSteps < realCurrentSteps - increment) {
        // 让数字动
        this.setData({
          currentSteps: Math.floor(this.data.currentSteps + increment)
        });
        // 画进度条
        if (this.data.currentSteps <= this.data.targetSteps) {
          this.drawProgressCanvas();
        }
        this.dynamicDrawCanvas(realCurrentSteps, increment);
      } else {
        this.setData({
          currentSteps: realCurrentSteps
        });
      }
    }, 10);
  },

  // 获取数据之后的进度canvas
  drawProgressCanvas() {
    const rate = this.data.progressCanvasRate,
      context = this.data.progressCanvasContext,
      currentSteps = (this.data.currentSteps > this.data.targetSteps ? this.data.targetSteps : this.data.currentSteps) || 0,
      targetSteps = this.data.targetSteps || 1,
      progressValue = currentSteps / targetSteps;
    context.translate(375 * rate, 255 * rate);
    // 画进度条总长
    context.setStrokeStyle('rgba(255, 255, 255, 0.4)');
    context.setLineWidth(4 * rate);
    context.setLineCap('round');
    context.beginPath();
    context.arc(0, 0, 245 * rate, 0.90625 * Math.PI, 2.09375 * Math.PI, false);
    context.stroke();
    // 画进度条当前长
    context.setStrokeStyle('#ffffff');
    context.beginPath();
    context.arc(0, 0, 245 * rate, 0.90625 * Math.PI, (1.1875 * progressValue + 0.90625) * Math.PI, false);
    context.stroke();
    // 画刻度
    context.setStrokeStyle('#ffffff');
    context.setLineWidth(4 * rate);
    context.rotate(-0.09375 * Math.PI);
    context.beginPath();
    const keduLeft = -230 * rate,
      keduRight = -220 * rate,
      oneKedu = 0.03125 * Math.PI;
    context.moveTo(keduLeft, 0);
    context.lineTo(keduRight, 0);
    context.stroke();
    for (let i = 0; i < 38; i++) {
      context.rotate(oneKedu);
      context.beginPath();
      context.moveTo(keduLeft, 0);
      context.lineTo(keduRight, 0);
      context.stroke();
    }
    // 画步数0，中值，末值
    context.save();
    context.setFillStyle('rgba(255, 255, 255, 0.4)');
    context.setFontSize(22 * rate);
    context.setTextAlign('center');
    context.rotate(0.342 * Math.PI);
    context.fillText((this.data.targetSteps?'0':''), 0 * rate, -188 * rate);
    context.rotate(0.56 * Math.PI);
    context.fillText(String(Math.floor(this.data.targetSteps / 2) || ''), 0 * rate, -188 * rate);
    context.rotate(0.56 * Math.PI);
    context.fillText((this.data.targetSteps || ''), 0 * rate, -188 * rate);
    // 画当前圆球
    context.setFillStyle('#ffffff');
    context.rotate((1.1932 * progressValue - 0.653) * Math.PI);
    context.arc(-245 * rate, 0, 7 * rate, 0, 2 * Math.PI, false);
    context.fill();
    // 画
    context.draw(false, drawRes => {
      if (drawRes.errMsg === 'drawCanvas:ok') {
        wx.canvasToTempFilePath({
          canvasId: 'progressCanvas',
          success:(ImageRes) => {
            this.setData({
              progressCanvasImage: ImageRes.tempFilePath
            });
          }
        });
      } else {
        this.drawProgressCanvas();
      }
    });
  },

  // 获取微信步数失败处理，包括未授权、设备不支持等
  getWeRunDataFail(err) {
    if ('device not support'.indexOf(err)) {
      wx.showModal({
        content: '设备不支持微信步数',
        showCancel: false
      });
    } else {
      this.authorizationFail();
    }
  },

  // 显示隐藏用户信息授权弹框
  showUserInfoPopup() {
    this.setData({
      showGetUserInfo: !this.data.showGetUserInfo
    });
  },

  // 用户同意授权
  onGotUserInfo(event) {
    console.log('onGotUserInfo')
    app.globalData.userAuth = true;
    this.setData({
      showGetUserInfo: !this.data.showGetUserInfo,
      userAuth: true
    });
    this.sendUserInfo(event.detail.encryptedData, event.detail.iv);
  },

  // 把用户授权信息传给后端,然后同步数据
  sendUserInfo(encryptedData, iv) {
    console.log('sendUserInfo',encryptedData, iv)
    wx.login({
      success:wxres => {
        if (wxres.code) {
          wx.request({
            url: config.service.hostUrl + "/v1/auth_login",
            data: {
              js_code: wxres.code,
              encrypted_data: encryptedData,
              iv: iv
            },
            method: 'POST',
            success:myres => {
              if (myres.data.code === 0) {
                app.globalData.unionAuth = true;
                this.setData({
                  unionAuth: app.globalData.unionAuth
                });
                app.globalData.userInfo = myres.data.data;
                app.globalData.token = myres.data.data.token;
                this.getClickStepData();
              }
            }
          });
        }
      }
    });
  },

  // 授权失败，去到openSetting页
  authorizationFail() {
    console.log('authorizationFail')
    wx.showModal({
      content: '如需完成步数打卡，请点击确定允许微信授权',
      success:(res) => {
        if (res.confirm) {
          wx.openSetting({
            success:(res) => {
              if (res.authSetting['scope.userInfo']) {
                app.globalData.userAuth = true;
                this.setData({
                  userAuth: true
                });
              } else {
                app.globalData.userAuth = false;
                this.setData({
                  userAuth: false
                });
              }
              if (res.authSetting['scope.werun']) {
                app.globalData.stepAuth = true;
                this.setData({
                  stepAuth: true
                });
              } else {
                app.globalData.stepAuth = false;
                this.setData({
                  stepAuth: false
                });
              }
            }
          });
        }
      }
    });
  },
  
  // 活动说明弹窗
  changeActivityExplainShow() {
    this.setData({
      activityExplainShow: !this.data.activityExplainShow
    });
  },
  
  // 活动说明弹窗
  showToast() {
    const scene = this.data.scene,
      currentSteps = this.data.currentSteps,
      targetSteps = this.data.targetSteps;
    if (targetSteps) { // 报名比赛了
      let content = '';
      if (scene === 1048) { // 场景值是二维码进来
        if (currentSteps >= targetSteps) { // 步数达标
          content = '恭喜你今日步数已达标';
        } else {
          content = '提交今日步数成功';
        }
      } else {
        if (currentSteps >= targetSteps) {
          content = '恭喜你今日步数已达标，去比赛详情页查看步数是否提交成功';
        } else {
          content = '提交今日步数成功，去继续行走吧';
        }
      }
      wx.showToast({
        title: content,
        icon: 'none',
        duration: 2000
      });
    } else {
      wx.showToast({
        title: '提交今日步数成功',
        icon: 'none',
        duration: 2000
      });
    }
  },

  // 赚步数的跳转气泡
  earnStep() {
    console.log('earnStep')
    if (!app.globalData.token) {
      return setTimeout(() => {
        this.earnStep();
      }, 200);
    }
    let requestData = {
      url: config.service.hostUrl + "/v1/user_task",
      header: {
        'Authorization': app.globalData.token
      },
      success:res => {
        console.log('earnStep',res)
        if (res.data.code === 0) {
          this.setData({
            bubbleList: res.data.data
          });
        }
      }
    }
    if (app.globalData.referrerAppid && app.globalData.scene === 1038) {
      const bubbleLeaveTime = wx.getStorageSync('bubbleLeaveTime') || 0;
      const bubbleId = wx.getStorageSync('bubbleId');
      if (Date.now() - bubbleLeaveTime > 10000 && bubbleId) { // 体验成功,可以加步数
        requestData.data = {
          task_id: bubbleId
        };
        requestData.method = 'POST';
        requestData.success = res => {
          console.log('earnStep',res)
          if (res.data.code === 0) {
            wx.showToast({
              title: '恭喜赚取步数成功',
              icon: 'none',
              duration: 2000
            });
            this.setData({
              bubbleList: res.data.data
            });
          }
        };
      } else {
        return wx.showToast({
          title: '体验不达标,获赠步数失败',
          icon: 'none',
          duration: 2000
        })
      }
    }
    wx.request(requestData);
  },

  // 点击气泡
  clickBubble(event) {
    console.log('event',event.currentTarget.dataset.item)
    const item = event.currentTarget.dataset.item;
    if (item.task_type === 1) { // 打开小程序
      wx.navigateToMiniProgram({
        appId: item.task_content,
        success: res => {
          if (res.errMsg === "navigateToMiniProgram:ok") {
            wx.setStorageSync('bubbleLeaveTime', Date.now());
            wx.setStorageSync('bubbleId', item.task_id);
          }
        }
      });
    }
  },

  // 暂留==================================================================

  // 通过code2session方式拿unionid
  // byCode2session() {
  //   wx.login({
  //     success:wxres => {
  //       if (wxres.code) {
  //         wx.request({
  //           url: 'https://api.weixin.qq.com/sns/jscode2session',
  //           data: {
  //             appid: 'wx035eac0d4d63b3e4',
  //             secret: 'cbb0d286083bee53e44f9518621eedb3',
  //             js_code: wxres.code,
  //             grant_type: 'authorization_code'
  //           },
  //           method: 'GET',
  //           success:res => {
  //             console.log('通过code2session方式拿unionid：',res.data.unionid)
  //           }
  //         });
  //       }
  //     }
  //   });
  // },

  // 同步步数成功弹窗
  // changeShowPopup() {
  //   this.setData({
  //     commitStepPopupShow: !this.data.commitStepPopupShow
  //   });
  // },

  // goAuthorizationPage() {
  //   console.log(`/pages/authorization/authorization?userAuth=${this.data.userAuth}&stepAuth=${this.data.stepAuth}`)
  //   wx.navigateTo({
  //     url: `/pages/authorization/authorization?userAuth=${this.data.userAuth}&stepAuth=${this.data.stepAuth}`
  //   });
  // },

  // goCaptionPage() {
  //   wx.navigateTo({
  //     url: '/pages/caption/caption'
  //   });
  // },
})