let app = getApp();
let getAuthLoading = false;
Page({
  data: {
    userAuth: false,
    stepAuth: false,
    stepGoSetting: true, // 步数授权是否变成直接去openSetting页的按钮
  },
  
  onLoad() {
    wx.getSetting({
      success:(res) => {
        // 用户信息是否授权
        if (res.authSetting['scope.userInfo']) { // 已授权
          app.globalData.userAuth = true;
        } else { // 未授权
          app.globalData.userAuth = false;
        }
        // 微信步数是否授权
        let stepGoSetting = true;
        if (res.authSetting['scope.werun'] === undefined) { // 未弹出过授权
          app.globalData.stepAuth = false;
          stepGoSetting = false;
        } else if (res.authSetting['scope.werun'] === false) { // 拒绝过授权
          app.globalData.stepAuth = false;
        } else if (res.authSetting['scope.werun'] === true) { // 已授权
          app.globalData.stepAuth = true;
        } else { // 未知情况
          app.globalData.stepAuth = false;
        }
        this.setData({
          userAuth: app.globalData.userAuth,
          stepAuth: app.globalData.stepAuth,
          stepGoSetting: stepGoSetting
        });
      }
    });
  },

  goSetting() {
    wx.openSetting({
      success:(res) => {
        if (res.authSetting['scope.userInfo']) {
          app.globalData.userAuth = true;
          this.setData({
            userAuth: true
          });
        } else {
          app.globalData.userAuth = false;
          this.setData({
            userAuth: false
          });
        }
        if (res.authSetting['scope.werun']) {
          app.globalData.stepAuth = true;
          this.setData({
            stepAuth: true
          });
        } else {
          app.globalData.stepAuth = false;
          this.setData({
            stepAuth: false
          });
        }
        this.checkAuth();
      }
    });
  },

  getUserAuth(event) {
    if (getAuthLoading) return;
    getAuthLoading = true;
    if (event.detail.errMsg === 'getUserInfo:ok') {
      console.log('getUserAuth:ok', event.detail)
      app.globalData.userAuth = true;
      this.setData({
        userAuth: true
      });
      this.checkAuth();
    } else {
      console.log('getUserAuth:fail', event)
      wx.showToast({
        title: '授权失败，请重新点击按钮发起授权',
        icon: 'none',
        duration: 1500
      });
    }
    setTimeout(() => {
      getAuthLoading = false;
    }, 100);
  },

  getStepAuth() {
    if (getAuthLoading) return;
    getAuthLoading = true;
    wx.authorize({
      scope: 'scope.werun',
      success:() => {
        app.globalData.stepAuth = true;
        this.setData({
          stepAuth: true
        });
        this.checkAuth();
      },
      fail:() => {
        this.setData({
          stepGoSetting: true
        });
      },
      complete: () => {
        setTimeout(() => {
          getAuthLoading = false;
        }, 100);
      }
    });
  },
  
  checkAuth() {
    if (app.globalData.userAuth && app.globalData.stepAuth) {
      wx.navigateBack({
        delta: 1
      });
    }
  }
})