var config = require('./config');
var app = null;
var isFirstRun = true;
var getConfigCount = 0;
App({
  globalData: {
    isBeta: true,
    defautWords: [],
    maxWordsLen: 22,
    canCustomWords: false,
    exampleRno: "example01",
    competedMinAmount: 1,
    competedMinNum: 2,
    maxAmount: 10000,
    minAmount: 1,
    maxNum: 500,
    rate: 0.02,
    canUseBalance: true,
    showContactButton: true, // 首页显示客服按钮
    indexAd: null,
    selectedWords: null, // 从口令库中选择的口令
    hasLogin: false,
    screenwidth: null,
    shareTitle: '步数打卡',
    init: 0,
    uid: -1,
    rid: -1,
    curPage: '',
    scene: -1,
    pageVal: '',
    systemInfo: "",
    appShowOptions: null,
    platform: '',
    ifIphoneX: false,
    SDKVersion: '9.9.9',
    statusBarHeight: 24,
    navBarHeight: 64,
    selectedCover: -1,
    selectedCoverItem: null,
    cover: [],
    navHeight: 128,
    tmpItem: null,
    initShareImg: '../../images/common/shareCard.jpg',
    initShareTitle: '步数打卡',
    //数据统计部分
    launchSource: "",
    //userLevel 用户层级数，默认值(自发使用)为1
    userLevel: 1,
    //pay页面收到分享卡片的时间戳
    payLastTimeStmp: '',

    userInfo: '', // 用户后端登录的userInfo
    token: '', // 用户后端登录的token
    userAuth: false, // 用户信息授权（为了拿unionId）
    unionAuth: false, // unionId授权: 如果为false是需要授权，true是不需要
    stepAuth: false, // 步数授权
  },

  onLaunch(options) {
    app = this;
    // qcloud.setLoginUrl(config.service.loginUrl);

    if (options.query && options.query.rid) {
      app.globalData.rid = options.query.rid
    }
    //数据统计-用户来源
    if (options.query && options.query.source) {
      app.globalData.launchSource = options.query.source
    }
    //数据统计-设置用户等级
    if (options.query && options.query.level) {
      app.globalData.userLevel = Number(options.query.level) + 1
    }
    //场景值
    if (options.scene) {
      app.globalData.scene = options.scene
    }

    // app.globalData.localData = wx.getStorageSync("initData")
    // app.setGlobalData(JSON.parse(app.globalData.localData || "{}"))

    this.setNavBarConfig();
    app.globalData.systemInfo = app.computeSystemInfo();
  },
  
  onShow(options) {
    console.log("app onshow options:", options)
    const uid = wx.getStorageSync('uid')
    if (uid) {
      app.globalData.uid = uid
    }
    //数据统计-设置用户等级
    if (options.query && options.query.level) {
      app.globalData.userLevel = Number(options.query.level) + 1
    }
    //数据统计-小程序跳转场景
    app.globalData.referrerAppid = options.referrerInfo && options.referrerInfo.appId ? options.referrerInfo.appId : ''
    if (options.referrerInfo && options.referrerInfo.appId) {
      console.log('navigateToMiniProgram**report')
      app.reportSource(options)
    }
    //数据统计-发送reportSource数据
    if (app.globalData.uid && app.globalData.uid != -1) {
      console.log('onShow**report')
      if (isFirstRun || (options.query.t && app.globalData.payLastTimeStmp != options.query.t && options.path == "pages/index/index")
      ) {
        app.reportSource(options)
      }
    } else {
      app.globalData.appShowOptions = options;
    }
    //场景
    if (options.scene) {
      app.globalData.scene = options.scene
    }
  },

  // 初始化自定义导航栏的宽高等数据
  setNavBarConfig() {
    getConfigCount ++;
    if (getConfigCount >= 100) return;
    try {
      let res = wx.getSystemInfoSync();
      if (!res || res.screenHeight <= 0 || res.screenWidth <= 0 || res.windowHeight <= 0 || res.windowWidth <= 0) {
        console.log('getConfig Fail');
        app.setNavBarConfig();
        return;
      }
      config.pixelRate = res.windowWidth / 750;
      config.platform = res.platform;
      config.statusBarHeight = res.statusBarHeight;
      if (res.platform.toLowerCase() == 'android') {
        config.capsuleHeight += 4;
      }
      config.titleHeight = (config.capsuleHeight + config.statusBarHeight) / config.pixelRate;
      if (res.statusBarHeight >= 44) {
        config.isHighHead = true;
      }
      if (res.windowHeight > 750) config.isAllScreen = true;
      config.systemHeight = res.windowHeight;
      app.globalData.navHeight = (config.statusBarHeight + config.capsuleHeight) / config.pixelRate
    } catch (e) {
      console.log('getConfig Fail',e);
      app.setNavBarConfig();
      return;
    }
  },

  // 初始化用户手机基本数据
  computeSystemInfo() {
    const info = wx.getSystemInfoSync()
    var infoString = ""
    console.log('info', info);
    if (info) {
      app.globalData.statusBarHeight = info.statusBarHeight
      app.globalData.SDKVersion = info.SDKVersion
      app.globalData.platform = info.platform
      app.globalData.sWidth = info.screenWidth
      app.globalData.wHeight = info.windowHeight

      if (info.screenHeight / info.screenWidth >= 812 / 375) {
        app.globalData.ifIphoneX = true
      }

      var infoArray = []
      infoArray.push(info.version.slice(0, 10) || "")
      infoArray.push(info.platform.slice(0, 10) || "")

      var brand = ""
      if (info.brand) {
        brand = info.brand.slice(0, 10)
      }
      infoArray.push(brand)
      infoString = infoArray.join("|")
    }
    return infoString
  },

  setGlobalData(data) {
    console.log('Initdata', data)
    app.globalData.isBeta = data.isBeta || false
    app.globalData.defaultWords = data.defaultWords || app.globalData.defautWords
    app.globalData.maxWordsLen = data.maxWordsLen || 22
    app.globalData.canCustomWords = data.customWords == 1 ? true : false
    app.globalData.exampleRno = data.exampleRno || "example01"
    app.globalData.maxAmount = data.maxAmount || 100
    app.globalData.minAmount = data.minAmount || 1
    app.globalData.competedMinNum = data.competedMinNum || 2;
    app.globalData.competedMinAmount = data.competedMinAmount || 1;
    app.globalData.maxNum = data.maxNum || 500
    app.globalData.rate = data.rate || 0.02
    app.globalData.showContactButton = data.contactBtn == 0 ? false : true
    app.globalData.indexAd = data.ad || {
      adStatus: 0
    };
    app.globalData.cover = data.cover || [];
    app.globalData.imgHost = data.imgHost || '';
    app.globalData.homeTopImg = data.homeTopImg || '../../images/common/home_img_top.png'
  },

  //数据统计-sourceReport接口调用
  reportSource: function(options) {
    console.log('send sourceReport')
    let source = ''
    let rid = ''
    let level = ''
    if (options.query && options.query.source) {
      source = options.query.source
    } else {
      source = app.globalData.launchSource
    }
    // if(app.globalData.uid == 1037225 ){
    //     source = 'lzh-test'
    // }
    if (options.query && options.query.rid) {
      rid = options.query.rid || app.globalData.rid
    } else {
      rid = app.globalData.rid
    }
    if (app.globalData.rid == app.globalData.uid) {
      level = app.globalData.userLevel--
    } else {
      level = app.globalData.userLevel || ''
    }
    let reportData = {
      originalId: config.service.originalId || -1,
      uid: app.globalData.uid,
      version: config.service.version,
      path: options.path,
      scene: options.scene || '',
      source: source,
      referrerAppid: options.referrerInfo && options.referrerInfo.appId ? options.referrerInfo.appId : '',
      query: JSON.stringify(options.query),
      rid: rid,
      shareCard: app.globalData.shareCardLink || '',
      level: level
    }
    console.log('[统计数据]:', reportData)
    wx.request({
      url: config.service.hostUrl + "/sourceReport",
      method: "POST",
      header: {
        'content-type': 'application/x-www-form-urlencoded'
      },
      data: reportData,
      success(result) {
        isFirstRun = false
        // console.log('success to report',result)
        // console.log('reportSource发送数据level',result.data.data.level)
        // console.log('reportSource发送数据source',result.data.data.source)
        if (result.data.code == 0 && result.data.length > 1) {
          app.globalData.launchSource = result.data.data.source
          app.globalData.userLevel = result.data.data.level
        }
      },
      fail(error) {
        console.log('fail to report')
      }
    });
  },
});