const config = require('../../config')
const app = getApp()
var page = [];
Component({
  properties: {
    navColor: {
      type: String,
      value: "",
    },
    titleColor:{
        type: String,
        value: "#ffffff",
    },
    showNavBar: {
      type: Boolean,
      value: true,
    },
    navTitle: {
      type: String,
      value: "",
    },
    showHome: {
      type: Boolean,
      value: false,
    },
    showBack: {
      type: Boolean,
      value: false,
    },
    showMargin: {
      type: Boolean,
      value: true
    },
    showExit: {
      type: Boolean,
      value: false
    },
    showBtnBg: {
      type: Boolean,
      value: true
    },
    backColor: {
      type: String,
      value: 'white'
    },
    paddingColor: {
      type: String,
      value: 'transparent'
    }
  },

  data: {
    homeTop: 18,
    titleFontSize: 36,
    titleFontWeight: 500,
    navBarTop: 0,
    titleTop: 20,

    capsuleHeight: config.capsuleHeight,
    statusBarHeight: config.statusBarHeight,
    pixelRate: config.pixelRate,
  },

  ready: function () {
    page = getCurrentPages();
    // console.log("page", page);
    let homePages = ['pages/index/index']
    
    app.globalData.navHeight = (this.data.statusBarHeight + this.data.capsuleHeight) / this.data.pixelRate
    // console.log('navHeight', app.globalData.navHeight);
    this.setData({
      capsuleHeight: config.capsuleHeight,
      statusBarHeight: config.statusBarHeight,
      pixelRate: config.pixelRate
    })
    if (page.length > 2) {
      this.setData({
        showBack: true,
        showHome: true
      })
    } else if (page.length === 2) {
      this.setData({
        showBack: true,
        showHome: false
      })
    } else {
      if (homePages.includes(page[0].route)) {
        this.setData({
          showBack: false,
          showHome: false
        })
      } else {
        this.setData({
          showBack: false,
          showHome: true
        })
      }
    }
  },

  methods: {
    tapNavHome() {
      wx.reLaunch({
        url: "/pages/index/index",
      })
    },
    tapNavBack() {
      wx.navigateBack({
        delta: 1
      })
    }
  },
})
