import Vue from 'vue'
import Router from 'vue-router'
import Courses from './views/Courses.vue'
import Daka from './views/Daka.vue'
import Read from './views/Read.vue'
import Reading from './views/Reading.vue'
import SignUp from './views/SignUp.vue'
import UserCenter from './views/UserCenter.vue'
import MainPage from './views/MainPage.vue'
import Question from './views/Question.vue'
import Wallet from './views/Wallet.vue'
import Author from './views/Author.vue'
import Record from './views/Record.vue'
import Success from './views/Success.vue'
import RecordDetail from './views/RecordDetail.vue'
import Rule from './views/Rule.vue'
import RedpackLog from './views/RedpackLog.vue'
import AmountDetail from './views/AmountDetail.vue'
import PartakeChallenge from './views/PartakeChallenge.vue'
import ChallengeDetail from './views/ChallengeDetail.vue'
import HaveJoinedGame from './views/HaveJoinedGame.vue'
import GoXCX from './views/GoXCX.vue'

Vue.use(Router)

export default new Router({
  routes: [
    {
      path:"/",
      redirect:"/MainPage/SignUp"
    },
    {
      path: '/Author',
      name: 'Author',
      component: Author
    },
    {
      path: '/Success',
      name: 'Success',
      component: Success
    },
    {
      path: '/Daka',
      name: 'Daka',
      component: Daka
    },
    {
      path: '/Record',
      name: 'Record',
      component: Record
    },
    {
      path: '/RecordDetail',
      name: 'RecordDetail',
      component: RecordDetail
    },
    {
      path: '/AmountDetail',
      name: 'AmountDetail',
      component: AmountDetail
    },
    {
      path: '/MainPage/Reading',
      name: 'Reading',
      component: Reading
    },
    {
      path: '/Question',
      name: 'Question',
      component: Question
    },
    {
      path: '/Wallet',
      name: 'Wallet',
      component: Wallet
    },
    {
      path: '/RedpackLog',
      name: 'RedpackLog',
      component: RedpackLog
    },
    {
      path: '/PartakeChallenge',
      name: 'PartakeChallenge',
      component: PartakeChallenge
    },
    {
      path: '/ChallengeDetail',
      name: 'ChallengeDetail',
      component: ChallengeDetail
    },
    {
      path: '/Rule',
      name: 'Rule',
      component: Rule
    },
    {
      path: '/HaveJoinedGame',
      name: 'HaveJoinedGame',
      component: HaveJoinedGame
    },
    {
      path: '/GoXCX',
      name: 'GoXCX',
      component: GoXCX
    },
    {
      path: '/MainPage',
      name: 'MainPage',
      component: MainPage,
      children:[
        {
          path:"/",
          redirect: "/MainPage/SignUp"
        },
        {
          path: '/MainPage/SignUp',
          name: 'SignUp',
          component: SignUp
        },
        {
          path: '/MainPage/PartakeChallenge',
          name: 'MainPagePartakeChallenge',
          component: PartakeChallenge
        },
        {
          path: '/MainPage/HaveJoinedGame',
          name: 'MainPageHaveJoinedGame',
          component: HaveJoinedGame
        },
        {
          path: '/UserCenter',
          name: 'UserCenter',
          component: UserCenter
        },
      ]
    },
    {
      path:"*",
      redirect:"/MainPage/SignUp"
    },
  ]
})
