import {fetch} from "./fetch"; //引用fetch.js
import api from './url'; //引用url.js

function getPlatform() {
  var u = navigator.userAgent,
    app = navigator.appVersion;
  var isAndroid = u.indexOf("Android") > -1 || u.indexOf("Linux") > -1; //g
  var isIOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
  if (isAndroid) {
    return "android";
  }
  if (isIOS) {
    return "ios";
  }
}

//打卡查询
export function dakaStatus() { //lookOption是你要调用接口的名字，issuer,userId是传进来的参数
  return fetch({
    url: api.dakaStatusPath,
    method: 'GET',
    params: {
      //传过去的参数
    }
  })
}

// 打卡操作
export function daka(use_rebirth) { //lookOption是你要调用接口的名字，issuer,userId是传进来的参数
  return fetch({
    url: api.dakaPath,
    method: 'GET',
    params: {
      //传过去的参数
      use_rebirth: use_rebirth || 0,
    }
  })
}

// 打卡总计
export function dakaRecordTotal() {
  return fetch({
    url: api.dakaRecordsTotalPath,
    method: 'GET',
    params: {
      //传过去的参数
    }
  })
}

// 打卡记录列表
export function dakaRecordList(page, perpage) {
  return fetch({
    url: api.dakaRecordsListPath,
    method: 'GET',
    params: {
      //传过去的参数
      // 第几页(从1开始)
      page: page,
      // 每页多少(默认为10)
      per_page: perpage
    }
  })
}

// 打卡总计
export function dakaRecordDetail(page, perpage, period, daka) {
  return fetch({
    url: api.dakaRecordsDetailPath,
    method: 'GET',
    params: {
      //传过去的参数
      // 第几页(从1开始)
      page: page,
      // 每页多少(默认为10)
      perpage: perpage,
      period: period,
      daka: daka
    }
  })
}

// 走马灯，玩法
export function gameInfo() {
  return fetch({
    url: api.gameInfoPath,
    method: 'GET',
    params: {
      //传过去的参数
    }
  })
}

// 余额查询
export function balanceQuery() {
  return fetch({
    url: api.balanceQueryPath,
    method: 'GET',
    params: {
      //传过去的参数
    }
  })
}

// 余额提现
export function balanceWithdraw(money, code) {
  let params = {}
  if (code) {
    params["js_code"] = code
  } else {
    params["money"] = money
  }
  return fetch({
    url: api.balanceWithdrawPath,
    method: 'GET',
    params: params
  })
}

// 常见问题
export function faq() { //lookOption是你要调用接口的名字，issuer,userId是传进来的参数
  return fetch({
    url: api.faqPath,
    method: 'GET',
    params: {
      //传过去的参数
    }
  })
}

// 客服
export function kefu() { //lookOption是你要调用接口的名字，issuer,userId是传进来的参数
  return fetch({
    url: api.kefuPath,
    method: 'GET',
    params: {
      //传过去的参数
    }
  })
}

// 关注公众号
export function ocFollow() { //lookOption是你要调用接口的名字，issuer,userId是传进来的参数
  return fetch({
    url: api.ocFollowPath,
    method: 'GET',
    params: {
      //传过去的参数
    }
  })
}

// 报名支付
export function dakaPay(days,use_contract) {
  let now = new Date();
  let year = now.getFullYear();
  let month = now.getMonth() + 1;
  let day = now.getDate();
  let date_time = new Date(`${year}/${month}/${day}`).getTime();
  let inviter = "";
  let from_type = "";
  if (Number(localStorage.getItem('last_share_time') || 0) >= date_time && !use_contract) {
    inviter = localStorage.getItem('inviter');
    from_type = localStorage.getItem('from_type');
  }
  return fetch({
    url: api.dakaPayPath,
    method: 'GET',
    params: {
      //传过去的参数
      //  platform:  ios, android, other
      platform: getPlatform(),
      use_contract: use_contract || 0,
      inviter_id: inviter || '',
      from_type: from_type || '',
      days: days || 0
    }
  })
}

// jssdk注入
export function jssdk(url) {
  return fetch({
    url: api.jssdkPath,
    method: 'GET',
    params: {
      //传过去的参数
      //  platform:  ios, android, other
      url: url
    }
  })
}

// 用户复活卡，免契约金卡信息
export function userCards() {
  return fetch({
    url: api.userCardPath,
    method: 'GET',
    params: {
      //传过去的参数
    }
  })
}

// 获取分享内容
export function shareContent(from_type) {
  return fetch({
    url: api.shareContentPath,
    method: 'GET',
    params: {
      //传过去的参数
      from_type: from_type || ''
    }
  })
}

// 获取规则内容
export function getRule() {
  return fetch({
    url: api.getRulePath,
    method: 'GET',
    params: {
      //传过去的参数
      from_type: from_type || ''
    }
  })
}


// 数据埋点
export function track(key) {
  return fetch({
    url: api.trackingPath,
    method: 'GET',
    params: {
      //传过去的参数
      p: `bsdk`,
      k: `${key}`,
      u: window['userData'] ? window['userData'].id : ''
    }
  })
}

// 立应关注分享图
export function liinShare(key) {
  var new_user = sessionStorage.getItem('new_user') ? 1 : 0;
  return fetch({
    url: api.liinShareImagePath,
    method: 'GET',
    params: {
      //传过去的参数
      new_user: new_user
    }
  })
}

// 每日分享图
export function dailyShare(from_type) {
  return fetch({
    url: api.dailyShareImagePath,
    method: 'GET',
    params: {
      //传过去的参数
      from_type: from_type || "daily_share"
    }
  })
}

// 打卡排行榜
export function dakaRank(page, per_page, period) {
  return fetch({
    url: api.dakaRankPath,
    method: 'GET',
    params: {
      //传过去的参数
      page: page || 1,
      per_page: per_page || 10,
      period: period || "",
    }
  })
}

// 新用户
export function firstDaka() {
  return fetch({
    url: api.firstDakaPath,
    method: 'GET',
    params: {}
  })
}

// 个人排名
export function personRank(period) {
  return fetch({
    url: api.personRankInfoPath,
    method: 'GET',
    params: {
      period: period
    }
  })
}

// 用户当月打卡状态查询
export function daka_status_list(year_month) {
  return fetch({
    url: api.daka_status_list,
    method: 'GET',
    params: {
      year_month: year_month || ""
    }
  })
}

// 每日故事详情
export function story_detail(story_id, story_index) {
  return fetch({
    url: api.story_detail,
    method: 'GET',
    params: {
      story_id: story_id,
      story_index: story_index,
    }
  })
}

// 每日故事列表
export function story_list() {
  return fetch({
    url: api.story_list,
    method: 'GET',
    params: {}
  })
}


// 记录详情
export function daka_records_detail(course_id) {
  return fetch({
    url: api.daka_records_detail,
    method: 'GET',
    params: {
      //传过去的参数
      course_id: course_id,
    }
  })
}

// 记录详情
export function daka_rule() {
  return fetch({
    url: api.daka_rule,
    method: 'GET',
    params: {
      //传过去的参数
    }
  })
}


// 红包图片
export function withdraw_img(position) {
  return fetch({
    url: api.withdraw_img,
    method: 'GET',
    params: {
      position: position || ""
    }
  })
}

// 资金明细
export function withdraw_log(page) {
  return fetch({
    url: api.withdraw_log,
    method: 'GET',
    params: {
      page: page,
      per_page: 10
    }
  })
}

// 首页数据
export function daka_index() {
  return fetch({
    url: api.daka_index,
    method: 'GET',
    params: {
    }
  })
}

// 判断用户是否参与比赛
export function select_user_signup() {
  return fetch({
    url: api.select_user_signup,
    method: 'GET',
    params: {
    }
  })
}

// 比赛详情
export function daka_status_detail(week) {
  return fetch({
    url: api.daka_status_detail,
    method: 'GET',
    params: {
      week: week
    }
  })
}

// 比赛详情弹窗
export function pop_up_windows() {
  return fetch({
    url: api.pop_up_windows,
    method: 'GET',
    params: {
    }
  })
}

//参与挑战
export function daka_info(){
  return fetch({
      url: api.daka_info,
      method: 'GET',
      params: {
      }
  })
}


//有新接口的时候像上面那样再来一次
// //修改昵称接口
// export function userID(name){
//   return fetch({
//     url:api.myself_name,
//     method:"put",
//     data:{
//       nickname:name
//     }
//   })
// }
//
//
// //取消转发赞踩接口
// export function cancelForward(articleId,type){
//   return fetch({
//     url:api.detail_article+articleId+"/forwarded_impress",
//     method:"delete",
//     params:{
//       type:type
//     }
//   })
// }
