import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from './store'
import axios from 'axios'
import wx from 'weixin-js-sdk'
import api from "@/components/axios/api"
// import VConsole from 'vconsole/dist/vconsole.min.js' //import vconsole
// let vConsole = new VConsole() // 初始化


Vue.config.productionTip = false
Vue.prototype.$http = axios;
window.wx = wx;

router.beforeEach((to, from, next) => {
  // document.title = to.meta.title		//修改各个页面的title
  var uid = localStorage.getItem('walk_userData');
  if (location.search.match(/inviter/)) {
    let searchs = location.search.split('&');
    let search_obj = {};
    searchs.map((item, index) => {
      if (index == 0) {
        let str = item.slice(1);
        let key_pair = str.split('=');
        search_obj[key_pair[0]] = key_pair[1];
      } else {
        let str = item;
        let key_pair = str.split('=');
        search_obj[key_pair[0]] = key_pair[1];
      }
    })

    let inviter_matchs = search_obj.inviter;
    let from_type_matchs = search_obj.from_type;
    let now = new Date();
    let year = now.getFullYear();
    let month = now.getMonth() + 1;
    let day = now.getDate();
    let date_time = new Date(`${year}/${month}/${day}`).getTime();
    // alert("test3:" + localStorage.getItem('last_share_time'))
    if (Number(localStorage.getItem('last_share_time') || 0) < date_time) {
      now && (localStorage.setItem('last_share_time', `${now.getTime()}`));
      // alert(inviter_matchs + "test1")
    }
    inviter_matchs && (localStorage.setItem("inviter", inviter_matchs));
    from_type_matchs && (localStorage.setItem('from_type', from_type_matchs));
  }

  console.log(to);
  to.params.replace = true;
  if (!uid && location.href.match(/\.wxatech\.com/)) {
    if (to.path === '/author') {
      next()
      // location.replace('#/author')
    } else {
      localStorage.setItem('last_url', to.path);
      next('/author')
      // location.replace('#/author')
    }
  } else if (to.name === 'MainPagePartakeChallenge' || to.name === 'MainPageHaveJoinedGame') {
    // 处理tabbar去‘比赛中’时，根据用户有没有参赛导向对应也页面
    const userHaveJoinGame = sessionStorage.getItem('userHaveJoinGame');
    if (userHaveJoinGame === 'true') {
      if (to.name === 'MainPageHaveJoinedGame') {
        next();
      } else {
        next({name: 'MainPageHaveJoinedGame'});
      }
    } else {
      if (to.name === 'MainPagePartakeChallenge') {
        next();
      } else {
        next({name: 'MainPagePartakeChallenge'});
      }
    }
  } else {
    next();
  }
})


new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app')
